<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttributeOptionsTable extends Migration
{
    public function up()
    {
        Schema::create('attribute_options', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('attribute_id');
            $table->string('name');
            $table->enum('type', ['quantity', 'amount', 'image'])->default('quantity');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('attribute_options');
    }
}
