<?php $__env->startSection('title'); ?> Site Setting <?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?> <body data-sidebar="dark"> <?php $__env->stopSection(); ?>
    <?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('components.breadcrumb'); ?>
    <?php $__env->slot('page_title'); ?> Site Setting <?php $__env->endSlot(); ?>
    <?php $__env->slot('subtitle'); ?> <a href="<?php echo e(route('settings.index')); ?>">Setting</a> <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="card-title">Site Setting</h4>
                    <p class="card-title-desc"></p>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('settings.update', ['setting' => $settingId ?? 1])); ?>"  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                            <input type="hidden" name="site_general_setting" value="1" />

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="site_title">Site Title</label>
                                <div bis_skin_checked="1">
                                    <input type="text" class="form-control" name="site_title" id="site_title" value="<?php echo e(old('site_title', $settings['site_title'] ?? '')); ?>" required>
                                </div>
                            </div>

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="admin_email">Email</label>
                                <div bis_skin_checked="1">
                                    <input type="text" class="form-control" name="admin_email" id="admin_email" value="<?php echo e(old('admin_email', $settings['admin_email'] ?? '')); ?>" required>
                                </div>
                            </div>

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="site_logo">⁠Logo ( Desktop )</label>
                                <?php if(isset($settings['site_logo_desktop']) && $settings['site_logo_desktop'] !=''): ?>
                                    <br>
                                    <img src="<?php echo e(asset( $settings['site_logo_desktop'])); ?>" width="150" alt="Site Desktop Logo" class="img-thumbnail mt-2" style="max-width: 150px;">
                                    <br><br>
                                <?php endif; ?>

                                <div bis_skin_checked="1">
                                    <input type="file" class="form-control" name="site_logo_desktop" id="site_logo_desktop" value="<?php echo e(old('site_logo', $settings['site_logo'] ?? '')); ?>" >
                                </div>
                            </div>

                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="site_logo">⁠Logo ( Mobile )</label>
                                <?php if(isset($settings['site_logo_mobile']) && $settings['site_logo_mobile'] !=''): ?>
                                    <br>
                                    <img src="<?php echo e(asset( $settings['site_logo_mobile'])); ?>"  width="150" alt="Site Mobile Logo" class="img-thumbnail mt-2" style="max-width: 150px;">
                                    <br><br>
                                <?php endif; ?>

                                <div bis_skin_checked="1">
                                    <input type="file" class="form-control" name="site_logo_mobile" id="site_logo_mobile" value="<?php echo e(old('site_logo_mobile', $settings['site_logo_mobile'] ?? '')); ?>" >
                                </div>
                            </div>




                            <div class="mb-3" bis_skin_checked="1">
                                <label class="form-label" for="site_logo">Favicon</label>
                                <?php if(isset($settings['site_favicon']) && $settings['site_favicon'] !='' ): ?>
                                    <br>
                                    <img src="<?php echo e(asset( $settings['site_favicon'])); ?>" alt="Site Logo" class="img-thumbnail mt-2" style="max-width: 75px;">
                                    <br><br>
                                <?php endif; ?>

                                <div bis_skin_checked="1">
                                    <input type="file" class="form-control" name="site_favicon" id="site_favicon" value="<?php echo e(old('site_favicon', $settings['site_favicon'] ?? '')); ?>" >
                                </div>
                            </div>

                            <div class="mb-3" bis_skin_checked="1">
                                <label  class="form-label" for="record_per_page">⁠Record Per Page</label>
                                <input type="number" name="record_per_page" id="record_per_page" class="form-control" value="<?php echo e(old('record_per_page', $settings['record_per_page'] ?? '')); ?>" required>
                            </div>



                                <div class="col-12" bis_skin_checked="1">
                                    <button class="btn btn-primary" type="submit">Save Setting</button>
                                </div>


                            </form>








                </div>
            </div>

        </div> <!-- end col -->
    </div> <!-- end row -->

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>



    <script src="<?php echo e(URL::asset('assets/js/app.js')); ?>"></script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\joodfm_admin\resources\views/setting/site-settting-all.blade.php ENDPATH**/ ?>