<?php
    use Illuminate\Support\Str;
?>

<?php $__env->startSection('title'); ?> All <?php echo e($title); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <!-- DataTables -->
    <link href="<?php echo e(URL::asset('assets/libs/datatables/datatables.min.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>

    <body data-sidebar="dark">
    <?php $__env->startSection('content'); ?>
        <?php $__env->startComponent('components.breadcrumb'); ?>
            <?php $__env->slot('page_title'); ?>
                All <?php echo e($title); ?>

            <?php $__env->endSlot(); ?>
            <?php $__env->slot('subtitle'); ?>
                <?php echo e(Str::ucfirst(Str::plural($title))); ?>

            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>



        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <?php if(session('success')): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>

                        <div class="row mb-3">
                            <div class="col-md-9"></div>
                            <div class="col-md-3">
                                
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-9"></div>
                            <div class="col-md-3">
                                <a href="<?php echo e(route($routePath . '.create')); ?>" class="btn btn-primary float-end">Add New</a>
                            </div>
                        </div>

                        <table id="datatable-grid"
                            class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline"
                            style="border-collapse: collapse; border-spacing: 0px; width: 100%;">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Location</th>


                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td>

                                            <?php if($record->image): ?>
                                                <img src="<?php echo e(asset($folderPath . '/' . $record->image)); ?>"
                                                    alt="<?php echo e($record->name); ?>" width="60" height="60"
                                                    class="img-thumbnail">
                                            <?php else: ?>
                                                <span class="text-muted">No Image</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($record->en_name); ?></td>
                                        <td><?php echo e($record->en_location); ?></td>



                                        <td>
                                            <a href="<?php echo e(route($routePath . '.edit', $record)); ?>" class="text-success mx-2">
                                                <i class="fas fa-marker" aria-hidden="true"></i>
                                            </a>
                                            <a href="#"
                                                onclick="confirmDelete('<?php echo e(route($routePath . '.destroy', $record)); ?>')"
                                                class="text-danger mx-2">
                                                <i class="fa fa-trash" aria-hidden="true"></i>
                                            </a>
                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6">No records found.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>

                        <script>
                            function confirmDelete(action) {
                                $('#deleteForm').attr('action', action);
                                $('#deleteConfirmationModal').modal('show');
                            }
                        </script>


                        <div class="modal fade" id="deleteConfirmationModal" data-bs-backdrop="static"
                            data-bs-keyboard="false" tabindex="-1" aria-labelledby="deleteConfirmationModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="deleteConfirmationModalLabel">
                                            <?php echo e(Str::ucfirst($title)); ?> Delete Confirmation</h5>
                                        </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        Are you sure you want to delete this <?php echo e(Str::ucfirst($title)); ?>?
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Cancel</button>
                                        <form id="deleteForm" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger">Delete</button>
                                        </form>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->


                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->

    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>

        <!-- Required datatable js -->
        <script src="<?php echo e(URL::asset('assets/libs/datatables/datatables.min.js')); ?>"></script>

        <script>
            $(document).ready(function() {

                var table = $('#datatable-grid').DataTable({
                    "pageLength": <?php echo e(get_records_per_page()); ?>,
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'colvis']
                });

                table.buttons().container()
                    .appendTo('#datatable-buttons_wrapper .col-md-6:eq(0)');

                $(".dataTables_length select").addClass('form-select form-select-sm');
            });
        </script>

        <script src="<?php echo e(URL::asset('assets/js/client_filter.js')); ?>"></script>

        <script src="<?php echo e(URL::asset('assets/js/app.js')); ?>"></script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\joodfm_admin\resources\views/admin/projects/index.blade.php ENDPATH**/ ?>